package com.ejie.ab18a.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aLinksPublicacion;

/**
 * Ab18a08s00DaoImpl generated by XXXX, 03-feb-2017 12:02:31.
 * 
 * @author XXXX
 */

@Repository
@Transactional
public class Ab18aLinksPublicacionDaoImpl implements Ab18aLinksPublicacionDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aLinksPublicacion> rwMap = new RowMapper<Ab18aLinksPublicacion>() {
		public Ab18aLinksPublicacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Ab18aLinksPublicacion(resultSet.getLong("T08IDLINK"),
					resultSet.getString("T08LINK"),
					resultSet.getLong("T01IDPETICIONENVIO"));
		}
	};

	private RowMapper<Ab18aLinksPublicacion> rwMapPK = new RowMapper<Ab18aLinksPublicacion>() {
		public Ab18aLinksPublicacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Ab18aLinksPublicacion(resultSet.getLong("T08IDLINK"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Ab18aLinksPublicacion>> rwMapJerarquia = new RowMapper<JerarquiaDto<Ab18aLinksPublicacion>>() {
		public JerarquiaDto<Ab18aLinksPublicacion> mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {

			Ab18aLinksPublicacion linkPublicacion = new Ab18aLinksPublicacion(
					resultSet.getLong("T08IDLINK"),
					resultSet.getString("T08LINK"),
					resultSet.getLong("T01IDPETICIONENVIO"));

			JerarquiaDto<Ab18aLinksPublicacion> jerarquia = new JerarquiaDto<Ab18aLinksPublicacion>();
			jerarquia.setModel(linkPublicacion);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab18a08s00 table.
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00
	 * @return Ab18a08s00
	 */
	public Ab18aLinksPublicacion add(Ab18aLinksPublicacion linkPublicacion) {
		String query = "INSERT INTO AB18A08S00 (T08_ID_LINK, T01_ID_PETICION_ENVIO, T08_LINK) VALUES (?,?,?)";

		this.jdbcTemplate.update(query, linkPublicacion.getT08IdLink(),
				linkPublicacion.getT01IdPeticionEnvio(),
				linkPublicacion.getT08Link());
		return linkPublicacion;
	}

	/**
	 * Updates a single row in the Ab18a08s00 table.
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00
	 * @return Ab18a08s00
	 */
	public Ab18aLinksPublicacion update(Ab18aLinksPublicacion linkPublicacion) {
		String query = "UPDATE AB18A08S00 SET T01_ID_PETICION_ENVIO=?, T08_LINK=? WHERE T08_ID_LINK=?";

		this.jdbcTemplate.update(query,
				linkPublicacion.getT01IdPeticionEnvio(),
				linkPublicacion.getT08Link(), linkPublicacion.getT08IdLink());
		return linkPublicacion;
	}

	/**
	 * Finds a single row in the Ab18a08s00 table.
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00
	 * @return Ab18a08s00
	 */
	@Transactional(readOnly = true)
	public Ab18aLinksPublicacion find(Ab18aLinksPublicacion linkPublicacion) {
		String query = "SELECT t1.T08_ID_LINK T08IDLINK, t1.T08_LINK T08LINK, t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO, t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA, t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP, t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML, t2.T01_ID_PODER AB18A01S00T01IDPODER, t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP, t2.T01_ID_ORGANO AB18A01S00T01IDORGANO, t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM, t2.T01_ID_MESA AB18A01S00T01IDMESA, t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO, t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS, t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR, t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM, t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE, t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA, t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO, t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN, t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO, t2.T07_ID_TICKET AB18A01S00T07IDTICKET, t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION, t2.T11_ID_ESTADO AB18A01S00T11IDESTADO FROM AB18A08S00 t1 , AB18A01S00 t2  WHERE t1.T08_ID_LINK = ?   AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+)";

		List<Ab18aLinksPublicacion> ab18a08s00List = this.jdbcTemplate.query(
				query, this.rwMap, linkPublicacion.getT08IdLink());
		return (Ab18aLinksPublicacion) DataAccessUtils
				.uniqueResult(ab18a08s00List);
	}

	/**
	 * Removes a single row in the Ab18a08s00 table.
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00
	 * @return
	 */
	public void remove(Ab18aLinksPublicacion linkPublicacion) {
		String query = "DELETE FROM AB18A08S00 WHERE T08_ID_LINK=?";
		this.jdbcTemplate.update(query, linkPublicacion.getT08IdLink());
	}

	/**
	 * Finds a list of rows in the Ab18a08s00 table.
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a08s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aLinksPublicacion> findAll(
			Ab18aLinksPublicacion linkPublicacion,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T08_ID_LINK T08IDLINK,t1.T08_LINK T08LINK,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		query.append("FROM AB18A08S00 t1 ,AB18A01S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(linkPublicacion);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aLinksPublicacion>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab18a08s00 table using like.
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a08s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aLinksPublicacion> findAllLike(
			Ab18aLinksPublicacion linkPublicacion,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T08_ID_LINK T08IDLINK,t1.T08_LINK T08LINK,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		query.append("FROM AB18A08S00 t1 ,AB18A01S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(linkPublicacion,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aLinksPublicacion>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab18a08s00 table.
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ab18aLinksPublicacion linkPublicacion) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB18A08S00 t1 , AB18A01S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(linkPublicacion);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab18a08s00 table using like.
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ab18aLinksPublicacion linkPublicacion,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB18A08S00 t1 ,AB18A01S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(linkPublicacion,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab18a08s00 selected for rup_table
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a08s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aLinksPublicacion>> reorderSelection(
			Ab18aLinksPublicacion linkPublicacion,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T08_ID_LINK T08IDLINK,t1.T08_LINK T08LINK,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		// FROM
		query.append("FROM AB18A08S00 t1 ,AB18A01S00 t2 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(linkPublicacion,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Ab18aLinksPublicacion.class,
				filterParamList, "T08_ID_LINK");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Ab18aLinksPublicacion>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Ab18a08s00
	 * @param searchParams
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a08s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aLinksPublicacion>> search(
			Ab18aLinksPublicacion filterParams,
			Ab18aLinksPublicacion searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T08_ID_LINK T08IDLINK,t1.T08_LINK T08LINK,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		// FROM
		query.append("FROM AB18A08S00 t1 ,AB18A01S00 t2 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Ab18aLinksPublicacion.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"T08_ID_LINK");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Ab18aLinksPublicacion>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filterab18a08s00
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Ab18aLinksPublicacion filterab18a08s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.T08_ID_LINK T08IDLINK,t1.T08_LINK T08LINK,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		// FROM
		query.append("FROM AB18A08S00 t1 ,AB18A01S00 t2 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab18a08s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						Ab18aLinksPublicacion.class, query, params,
						"T08_ID_LINK");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab18a08s00 table.
	 * 
	 * @param filterAb18a08s00
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Ab18a08s00>>
	 */
	@Override
	public List<JerarquiaDto<Ab18aLinksPublicacion>> findAllLikeJerarquia(
			Ab18aLinksPublicacion filterAb18a08s00,
			JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T08_ID_LINK T08IDLINK,t1.T08_LINK T08LINK,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A08S00 t1 ,AB18A01S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A08S00");
		from.add("AB18A01S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAb18a08s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "T08_ID_LINK", "ID_PADRE", "NOMBRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAb18a08s00
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(
			Ab18aLinksPublicacion filterAb18a08s00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A08S00 t1 ,AB18A01S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A08S00");
		from.add("AB18A01S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAb18a08s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "T08_ID_LINK", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAb18a08s00
	 *            Ab18a08s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Ab18a08s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aLinksPublicacion>> findAllChild(
			Ab18aLinksPublicacion filterAb18a08s00,
			JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A08S00 t1 ,AB18A01S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A08S00");
		from.add("AB18A01S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAb18a08s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "T08_ID_LINK", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Ab18aLinksPublicacion>(
						this.rwMapPK, "T08_ID_LINK"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a08s00 entity
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, ?> getWhereMap(Ab18aLinksPublicacion linkPublicacion) {

		StringBuilder where = new StringBuilder(
				Ab18aLinksPublicacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (linkPublicacion != null && linkPublicacion.getT08IdLink() != null) {
			where.append(" AND t1.T08_ID_LINK = ?");
			params.add(linkPublicacion.getT08IdLink());
		}

		if (linkPublicacion != null && linkPublicacion.getT08Link() != null) {
			where.append(" AND t1.T08_LINK = ?");
			params.add(linkPublicacion.getT08Link());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a08s00 entity
	 * 
	 * @param linkPublicacion
	 *            Ab18a08s00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, Object> getWhereLikeMap(
			Ab18aLinksPublicacion linkPublicacion, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Ab18aLinksPublicacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (linkPublicacion != null && linkPublicacion.getT08IdLink() != null) {
			where.append(" AND t1.T08_ID_LINK = ?");
			params.add(linkPublicacion.getT08IdLink());
		}

		if (linkPublicacion != null && linkPublicacion.getT08Link() != null) {
			where.append(" AND UPPER(t1.T08_LINK) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(linkPublicacion.getT08Link().toUpperCase() + "%");
			} else {
				params.add("%" + linkPublicacion.getT08Link().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T08_LINK IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
